# libunwind

**libunwind** is a portable and efficient C API for determining the current call
chain of ELF program threads of execution and for resuming execution at any point
in that call chain. The API supports both local (same process) and remote (other
process) operation.

The API is useful in a number of applications, including but not limited to the
following.
- **program introspection**
    Either for error messages showing a back trace of the call chain leading to
    a problem or for performance monitoring and analysis.
- **debugging**
    Whether the debugging and analysis of the call chain of a remote program or
    the post-mortem analysis of a coredump.
- **language runtime exception handling**
    **libunwind** optionally provides an alternative implementation of the
    Itanium exception handling ABI used by many popular toolchains.
- **alternative `setjmp()`/`longjmp()`**
    **libunwind** optionally provides an alternative implementation of the
    `setjmp()`/`longjmp()` functionality of the C standard library.

## Supported Systems

[![CI - Unix](https://github.com/libunwind/libunwind/actions/workflows/CI-unix.yml/badge.svg)](https://github.com/libunwind/libunwind/actions/workflows/CI-unix.yml)
[![CI - Windows](https://github.com/libunwind/libunwind/actions/workflows/CI-win.yml/badge.svg)](https://github.com/libunwind/libunwind/actions/workflows/CI-win.yml)

This library supports several architecture/operating-system combinations:

| System  | Architecture | Status |
| :------ | :----------- | :----- |
| Linux   | x86-64       | ✓      |
| Linux   | x86          | ✓      |
| Linux   | ARM          | ✓      |
| Linux   | AArch64      | ✓      |
| Linux   | PPC32        | ✓      |
| Linux   | PPC64        | ✓      |
| Linux   | SuperH       | ✓      |
| Linux   | IA-64        | ✓      |
| Linux   | PA-RISC      | Works well, but C library missing unwind-info |
| Linux   | MIPS         | ✓      |
| Linux   | RISC-V       | 64-bit only |
| Linux   | LoongArch    | 64-bit only |
| HP-UX   | IA-64        | Mostly works, but known to have serious limitations |
| FreeBSD | x86-64       | ✓      |
| FreeBSD | x86          | ✓      |
| FreeBSD | AArch64      | ✓      |
| FreeBSD | PPC32        | ✓      |
| FreeBSD | PPC64        | ✓      |
| FreeBSD | RISC-V       | 64-bit only |
| QNX     | Aarch64      | ✓      |
| QNX     | x86-64       | ✓      |
| Solaris | x86-64       | ✓      |

## Libc Requirements

libunwind depends on getcontext(), setcontext() functions which are missing
from C libraries like musl-libc because they are considered to be "obsolescent"
API by POSIX document.  The following table tries to track current status of
such dependencies

 - r, requires
 - p, provides its own implementation
 - empty, no requirement

| Architecture | getcontext | setcontext |
|--------------|------------|------------|
|    aarch64   |     p      |            |
|    arm       |     p      |            |
|    hppa      |     p      |      p     |
|    ia64      |     p      |      r     |
|    loongarch |     p      |            |
|    mips      |     p      |            |
|    ppc32     |     r      |            |
|    ppc64     |     r      |      r     |
|    riscv     |     p      |      p     |
|    s390x     |     p      |      p     |
|    sh        |     r      |            |
|    x86       |     p      |      r     |
|    x86\_64   |     p      |      p     |

## General Build Instructions

In general, this library can be built and installed with the following
commands:

    $ autoreconf -i # Needed only for building from git. Depends on libtool.
    $ ./configure --prefix=PREFIX
    $ make
    $ make install

where `PREFIX` is the installation prefix.  By default, a prefix of
`/usr/local` is used, such that `libunwind.a` is installed in
`/usr/local/lib` and `unwind.h` is installed in `/usr/local/include`.  For
testing, you may want to use a prefix of `/usr/local` instead.


### Building with Intel compiler

#### Version 8 and later

Starting with version 8, the preferred name for the IA-64 Intel
compiler is `icc` (same name as on x86).  Thus, the configure-line
should look like this:

    $ ./configure CC=icc CFLAGS="-g -O3 -ip" CXX=icc CCAS=gcc CCASFLAGS=-g \
        LDFLAGS="-L$PWD/src/.libs"


### Building on HP-UX

For the time being, libunwind must be built with GCC on HP-UX.

libunwind should be configured and installed on HP-UX like this:

    $ ./configure CFLAGS="-g -O2 -mlp64" CXXFLAGS="-g -O2 -mlp64"

Caveat: Unwinding of 32-bit (ILP32) binaries is not supported at the moment.

### Building for PowerPC64 / Linux

For building for power64 you should use:

    $ ./configure CFLAGS="-g -O2 -m64" CXXFLAGS="-g -O2 -m64"

If your power support altivec registers:

    $ ./configure CFLAGS="-g -O2 -m64 -maltivec" CXXFLAGS="-g -O2 -m64 -maltivec"

To check if your processor has support for vector registers (altivec):

    cat /proc/cpuinfo | grep altivec

and should have something like this:

    cpu             : PPC970, altivec supported

If libunwind seems to not work (backtracing failing), try to compile
it with `-O0`, without optimizations. There are some compiler problems
depending on the version of your gcc.

### Building on FreeBSD

General building instructions apply. To build and execute several tests
on older versions of FreeBSD, you need libexecinfo library available in
ports as devel/libexecinfo. This port has been removed as of 2017 and is
indeed no longer needed.

## Regression Testing

After building the library, you can run a set of regression tests with:

    $ make check

### Expected results on x86 Linux

The following tests are expected to fail on x86 Linux:

* `test-ptrace`

### Expected results on x86-64 Linux

All tests are expected to pass on x86_64-linux-gnu.

### Expected results on PA-RISC Linux

The following tests are expected to fail on hppa-linux-gnu hosts:

* `Gtest-bt` (backtrace truncated at `kill()` due to lack of unwind-info)
* `Ltest-bt` (likewise)
* `Gtest-resume-sig` (`Gresume.c:my_rt_sigreturn()` is wrong somehow)
* `Ltest-resume-sig` (likewise)
* `Gtest-init` (likewise)
* `Ltest-init` (likewise)
* `Gtest-dyn1` (no dynamic unwind info support yet)
* `Ltest-dyn1` (no dynamic unwind info support yet)
* `test-setjmp` (`longjmp()` not implemented yet)
* `run-check-namespace` (toolchain doesn't support `HIDDEN` yet)

### Expected results on HP-UX

`make check` is currently unsupported for HP-UX.  You can try to run
it, but most tests will fail (and some may fail to terminate).  The
only test programs that are known to work at this time are:

* `tests/bt`
* `tests/Gperf-simple`
* `tests/test-proc-info`
* `tests/test-static-link`
* `tests/Gtest-init`
* `tests/Ltest-init`
* `tests/Gtest-resume-sig`
* `tests/Ltest-resume-sig`

### Expected results on ppc64-linux-gnu

`make check` currently has the following failures.

* `Gtest-concurrent`
* `Ltest-concurrent`
* `Ltest-init-local-signal`
* `Gtest-exc`
* `Ltest-exc`
* `Gtest-resume-sig`
* `Ltest-resume-sig`
* `Gtest-resume-sig-rt`
* `Ltest-resume-sig-rt`

### Expected results on Solaris x86-64

`make check` is passing 27 out of 33 tests. The following six tests are consistently
failing:

* `Gtest-concurrent`
* `Ltest-concurrent`
* `Ltest-init-local-signal`
* `Lrs-race`
* `test-setjmp`
* `x64-unwind-badjmp-signal-frame`

## Performance Testing

This distribution includes a few simple performance tests which give
some idea of the basic cost of various libunwind operations.  After
building the library, you can run these tests with the following
commands:

    $ cd tests
    $ make perf

## Contacting the Developers

Please raise issues and pull requests through the GitHub repository:
<https://github.com/libunwind/libunwind>.
