#pragma once

/*
 *
 *
 * Constants for L4Re events ...
 */


enum L4Re_events_key
{
  L4RE_KEY_RESERVED         = 0,
  L4RE_KEY_ESC              = 1,
  L4RE_KEY_1                = 2,
  L4RE_KEY_2                = 3,
  L4RE_KEY_3                = 4,
  L4RE_KEY_4                = 5,
  L4RE_KEY_5                = 6,
  L4RE_KEY_6                = 7,
  L4RE_KEY_7                = 8,
  L4RE_KEY_8                = 9,
  L4RE_KEY_9                = 10,
  L4RE_KEY_0                = 11,
  L4RE_KEY_MINUS            = 12,
  L4RE_KEY_EQUAL            = 13,
  L4RE_KEY_BACKSPACE        = 14,
  L4RE_KEY_TAB              = 15,
  L4RE_KEY_Q                = 16,
  L4RE_KEY_W                = 17,
  L4RE_KEY_E                = 18,
  L4RE_KEY_R                = 19,
  L4RE_KEY_T                = 20,
  L4RE_KEY_Y                = 21,
  L4RE_KEY_U                = 22,
  L4RE_KEY_I                = 23,
  L4RE_KEY_O                = 24,
  L4RE_KEY_P                = 25,
  L4RE_KEY_LEFTBRACE        = 26,
  L4RE_KEY_RIGHTBRACE       = 27,
  L4RE_KEY_ENTER            = 28,
  L4RE_KEY_LEFTCTRL         = 29,
  L4RE_KEY_A                = 30,
  L4RE_KEY_S                = 31,
  L4RE_KEY_D                = 32,
  L4RE_KEY_F                = 33,
  L4RE_KEY_G                = 34,
  L4RE_KEY_H                = 35,
  L4RE_KEY_J                = 36,
  L4RE_KEY_K                = 37,
  L4RE_KEY_L                = 38,
  L4RE_KEY_SEMICOLON        = 39,
  L4RE_KEY_APOSTROPHE       = 40,
  L4RE_KEY_GRAVE            = 41,
  L4RE_KEY_LEFTSHIFT        = 42,
  L4RE_KEY_BACKSLASH        = 43,
  L4RE_KEY_Z                = 44,
  L4RE_KEY_X                = 45,
  L4RE_KEY_C                = 46,
  L4RE_KEY_V                = 47,
  L4RE_KEY_B                = 48,
  L4RE_KEY_N                = 49,
  L4RE_KEY_M                = 50,
  L4RE_KEY_COMMA            = 51,
  L4RE_KEY_DOT              = 52,
  L4RE_KEY_SLASH            = 53,
  L4RE_KEY_RIGHTSHIFT       = 54,
  L4RE_KEY_KPASTERISK       = 55,
  L4RE_KEY_LEFTALT          = 56,
  L4RE_KEY_SPACE            = 57,
  L4RE_KEY_CAPSLOCK         = 58,
  L4RE_KEY_F1               = 59,
  L4RE_KEY_F2               = 60,
  L4RE_KEY_F3               = 61,
  L4RE_KEY_F4               = 62,
  L4RE_KEY_F5               = 63,
  L4RE_KEY_F6               = 64,
  L4RE_KEY_F7               = 65,
  L4RE_KEY_F8               = 66,
  L4RE_KEY_F9               = 67,
  L4RE_KEY_F10              = 68,
  L4RE_KEY_NUMLOCK          = 69,
  L4RE_KEY_SCROLLLOCK       = 70,
  L4RE_KEY_KP7              = 71,
  L4RE_KEY_KP8              = 72,
  L4RE_KEY_KP9              = 73,
  L4RE_KEY_KPMINUS          = 74,
  L4RE_KEY_KP4              = 75,
  L4RE_KEY_KP5              = 76,
  L4RE_KEY_KP6              = 77,
  L4RE_KEY_KPPLUS           = 78,
  L4RE_KEY_KP1              = 79,
  L4RE_KEY_KP2              = 80,
  L4RE_KEY_KP3              = 81,
  L4RE_KEY_KP0              = 82,
  L4RE_KEY_KPDOT            = 83,
  L4RE_KEY_ZENKAKUHANKAKU   = 85,
  L4RE_KEY_102ND            = 86,
  L4RE_KEY_F11              = 87,
  L4RE_KEY_F12              = 88,
  L4RE_KEY_RO               = 89,
  L4RE_KEY_KATAKANA         = 90,
  L4RE_KEY_HIRAGANA         = 91,
  L4RE_KEY_HENKAN           = 92,
  L4RE_KEY_KATAKANAHIRAGANA = 93,
  L4RE_KEY_MUHENKAN         = 94,
  L4RE_KEY_KPJPCOMMA        = 95,
  L4RE_KEY_KPENTER          = 96,
  L4RE_KEY_RIGHTCTRL        = 97,
  L4RE_KEY_KPSLASH          = 98,
  L4RE_KEY_SYSRQ            = 99,
  L4RE_KEY_RIGHTALT         = 100,
  L4RE_KEY_LINEFEED         = 101,
  L4RE_KEY_HOME             = 102,
  L4RE_KEY_UP               = 103,
  L4RE_KEY_PAGEUP           = 104,
  L4RE_KEY_LEFT             = 105,
  L4RE_KEY_RIGHT            = 106,
  L4RE_KEY_END              = 107,
  L4RE_KEY_DOWN             = 108,
  L4RE_KEY_PAGEDOWN         = 109,
  L4RE_KEY_INSERT           = 110,
  L4RE_KEY_DELETE           = 111,
  L4RE_KEY_MACRO            = 112,
  L4RE_KEY_MUTE             = 113,
  L4RE_KEY_VOLUMEDOWN       = 114,
  L4RE_KEY_VOLUMEUP         = 115,
  L4RE_KEY_POWER            = 116,
  L4RE_KEY_KPEQUAL          = 117,
  L4RE_KEY_KPPLUSMINUS      = 118,
  L4RE_KEY_PAUSE            = 119,
  L4RE_KEY_KPCOMMA          = 121,
  L4RE_KEY_HANGEUL          = 122,
  L4RE_KEY_HANGUEL          = L4RE_KEY_HANGEUL,
  L4RE_KEY_HANJA            = 123,
  L4RE_KEY_YEN              = 124,
  L4RE_KEY_LEFTMETA         = 125,
  L4RE_KEY_RIGHTMETA        = 126,
  L4RE_KEY_COMPOSE          = 127,
  L4RE_KEY_STOP             = 128,
  L4RE_KEY_AGAIN            = 129,
  L4RE_KEY_PROPS            = 130,
  L4RE_KEY_UNDO             = 131,
  L4RE_KEY_FRONT            = 132,
  L4RE_KEY_COPY             = 133,
  L4RE_KEY_OPEN             = 134,
  L4RE_KEY_PASTE            = 135,
  L4RE_KEY_FIND             = 136,
  L4RE_KEY_CUT              = 137,
  L4RE_KEY_HELP             = 138,
  L4RE_KEY_MENU             = 139,
  L4RE_KEY_CALC             = 140,
  L4RE_KEY_SETUP            = 141,
  L4RE_KEY_SLEEP            = 142,
  L4RE_KEY_WAKEUP           = 143,
  L4RE_KEY_FILE             = 144,
  L4RE_KEY_SENDFILE         = 145,
  L4RE_KEY_DELETEFILE       = 146,
  L4RE_KEY_XFER             = 147,
  L4RE_KEY_PROG1            = 148,
  L4RE_KEY_PROG2            = 149,
  L4RE_KEY_WWW              = 150,
  L4RE_KEY_MSDOS            = 151,
  L4RE_KEY_COFFEE           = 152,
  L4RE_KEY_DIRECTION        = 153,
  L4RE_KEY_CYCLEWINDOWS     = 154,
  L4RE_KEY_MAIL             = 155,
  L4RE_KEY_BOOKMARKS        = 156,
  L4RE_KEY_COMPUTER         = 157,
  L4RE_KEY_BACK             = 158,
  L4RE_KEY_FORWARD          = 159,
  L4RE_KEY_CLOSECD          = 160,
  L4RE_KEY_EJECTCD          = 161,
  L4RE_KEY_EJECTCLOSECD     = 162,
  L4RE_KEY_NEXTSONG         = 163,
  L4RE_KEY_PLAYPAUSE        = 164,
  L4RE_KEY_PREVIOUSSONG     = 165,
  L4RE_KEY_STOPCD           = 166,
  L4RE_KEY_RECORD           = 167,
  L4RE_KEY_REWIND           = 168,
  L4RE_KEY_PHONE            = 169,
  L4RE_KEY_ISO              = 170,
  L4RE_KEY_CONFIG           = 171,
  L4RE_KEY_HOMEPAGE         = 172,
  L4RE_KEY_REFRESH          = 173,
  L4RE_KEY_EXIT             = 174,
  L4RE_KEY_MOVE             = 175,
  L4RE_KEY_EDIT             = 176,
  L4RE_KEY_SCROLLUP         = 177,
  L4RE_KEY_SCROLLDOWN       = 178,
  L4RE_KEY_KPLEFTPAREN      = 179,
  L4RE_KEY_KPRIGHTPAREN     = 180,
  L4RE_KEY_NEW              = 181,
  L4RE_KEY_REDO             = 182,
  L4RE_KEY_F13              = 183,
  L4RE_KEY_F14              = 184,
  L4RE_KEY_F15              = 185,
  L4RE_KEY_F16              = 186,
  L4RE_KEY_F17              = 187,
  L4RE_KEY_F18              = 188,
  L4RE_KEY_F19              = 189,
  L4RE_KEY_F20              = 190,
  L4RE_KEY_F21              = 191,
  L4RE_KEY_F22              = 192,
  L4RE_KEY_F23              = 193,
  L4RE_KEY_F24              = 194,
  L4RE_KEY_PLAYCD           = 200,
  L4RE_KEY_PAUSECD          = 201,
  L4RE_KEY_PROG3            = 202,
  L4RE_KEY_PROG4            = 203,
  L4RE_KEY_SUSPEND          = 205,
  L4RE_KEY_CLOSE            = 206,
  L4RE_KEY_PLAY             = 207,
  L4RE_KEY_FASTFORWARD      = 208,
  L4RE_KEY_BASSBOOST        = 209,
  L4RE_KEY_PRINT            = 210,
  L4RE_KEY_HP               = 211,
  L4RE_KEY_CAMERA           = 212,
  L4RE_KEY_SOUND            = 213,
  L4RE_KEY_QUESTION         = 214,
  L4RE_KEY_EMAIL            = 215,
  L4RE_KEY_CHAT             = 216,
  L4RE_KEY_SEARCH           = 217,
  L4RE_KEY_CONNECT          = 218,
  L4RE_KEY_FINANCE          = 219,
  L4RE_KEY_SPORT            = 220,
  L4RE_KEY_SHOP             = 221,
  L4RE_KEY_ALTERASE         = 222,
  L4RE_KEY_CANCEL           = 223,
  L4RE_KEY_BRIGHTNESSDOWN   = 224,
  L4RE_KEY_BRIGHTNESSUP     = 225,
  L4RE_KEY_MEDIA            = 226,
  L4RE_KEY_SWITCHVIDEOMODE  = 227,
  L4RE_KEY_KBDILLUMTOGGLE   = 228,
  L4RE_KEY_KBDILLUMDOWN     = 229,
  L4RE_KEY_KBDILLUMUP       = 230,
  L4RE_KEY_SEND             = 231,
  L4RE_KEY_REPLY            = 232,
  L4RE_KEY_FORWARDMAIL      = 233,
  L4RE_KEY_SAVE             = 234,
  L4RE_KEY_DOCUMENTS        = 235,
  L4RE_KEY_UNKNOWN          = 240,
  L4RE_KEY_OK               = 0x160,
  L4RE_KEY_SELECT           = 0x161,
  L4RE_KEY_GOTO             = 0x162,
  L4RE_KEY_CLEAR            = 0x163,
  L4RE_KEY_POWER2           = 0x164,
  L4RE_KEY_OPTION           = 0x165,
  L4RE_KEY_INFO             = 0x166,
  L4RE_KEY_TIME             = 0x167,
  L4RE_KEY_VENDOR           = 0x168,
  L4RE_KEY_ARCHIVE          = 0x169,
  L4RE_KEY_PROGRAM          = 0x16a,
  L4RE_KEY_CHANNEL          = 0x16b,
  L4RE_KEY_FAVORITES        = 0x16c,
  L4RE_KEY_EPG              = 0x16d,
  L4RE_KEY_PVR              = 0x16e,
  L4RE_KEY_MHP              = 0x16f,
  L4RE_KEY_LANGUAGE         = 0x170,
  L4RE_KEY_TITLE            = 0x171,
  L4RE_KEY_SUBTITLE         = 0x172,
  L4RE_KEY_ANGLE            = 0x173,
  L4RE_KEY_ZOOM             = 0x174,
  L4RE_KEY_MODE             = 0x175,
  L4RE_KEY_KEYBOARD         = 0x176,
  L4RE_KEY_SCREEN           = 0x177,
  L4RE_KEY_PC               = 0x178,
  L4RE_KEY_TV               = 0x179,
  L4RE_KEY_TV2              = 0x17a,
  L4RE_KEY_VCR              = 0x17b,
  L4RE_KEY_VCR2             = 0x17c,
  L4RE_KEY_SAT              = 0x17d,
  L4RE_KEY_SAT2             = 0x17e,
  L4RE_KEY_CD               = 0x17f,
  L4RE_KEY_TAPE             = 0x180,
  L4RE_KEY_RADIO            = 0x181,
  L4RE_KEY_TUNER            = 0x182,
  L4RE_KEY_PLAYER           = 0x183,
  L4RE_KEY_TEXT             = 0x184,
  L4RE_KEY_DVD              = 0x185,
  L4RE_KEY_AUX              = 0x186,
  L4RE_KEY_MP3              = 0x187,
  L4RE_KEY_AUDIO            = 0x188,
  L4RE_KEY_VIDEO            = 0x189,
  L4RE_KEY_DIRECTORY        = 0x18a,
  L4RE_KEY_LIST             = 0x18b,
  L4RE_KEY_MEMO             = 0x18c,
  L4RE_KEY_CALENDAR         = 0x18d,
  L4RE_KEY_RED              = 0x18e,
  L4RE_KEY_GREEN            = 0x18f,
  L4RE_KEY_YELLOW           = 0x190,
  L4RE_KEY_BLUE             = 0x191,
  L4RE_KEY_CHANNELUP        = 0x192,
  L4RE_KEY_CHANNELDOWN      = 0x193,
  L4RE_KEY_FIRST            = 0x194,
  L4RE_KEY_LAST             = 0x195,
  L4RE_KEY_AB               = 0x196,
  L4RE_KEY_NEXT             = 0x197,
  L4RE_KEY_RESTART          = 0x198,
  L4RE_KEY_SLOW             = 0x199,
  L4RE_KEY_SHUFFLE          = 0x19a,
  L4RE_KEY_BREAK            = 0x19b,
  L4RE_KEY_PREVIOUS         = 0x19c,
  L4RE_KEY_DIGITS           = 0x19d,
  L4RE_KEY_TEEN             = 0x19e,
  L4RE_KEY_TWEN             = 0x19f,
  L4RE_KEY_DEL_EOL          = 0x1c0,
  L4RE_KEY_DEL_EOS          = 0x1c1,
  L4RE_KEY_INS_LINE         = 0x1c2,
  L4RE_KEY_DEL_LINE         = 0x1c3,
  L4RE_KEY_FN               = 0x1d0,
  L4RE_KEY_FN_ESC           = 0x1d1,
  L4RE_KEY_FN_F1            = 0x1d2,
  L4RE_KEY_FN_F2            = 0x1d3,
  L4RE_KEY_FN_F3            = 0x1d4,
  L4RE_KEY_FN_F4            = 0x1d5,
  L4RE_KEY_FN_F5            = 0x1d6,
  L4RE_KEY_FN_F6            = 0x1d7,
  L4RE_KEY_FN_F7            = 0x1d8,
  L4RE_KEY_FN_F8            = 0x1d9,
  L4RE_KEY_FN_F9            = 0x1da,
  L4RE_KEY_FN_F10           = 0x1db,
  L4RE_KEY_FN_F11           = 0x1dc,
  L4RE_KEY_FN_F12           = 0x1dd,
  L4RE_KEY_FN_1             = 0x1de,
  L4RE_KEY_FN_2             = 0x1df,
  L4RE_KEY_FN_D             = 0x1e0,
  L4RE_KEY_FN_E             = 0x1e1,
  L4RE_KEY_FN_F             = 0x1e2,
  L4RE_KEY_FN_S             = 0x1e3,
  L4RE_KEY_FN_B             = 0x1e4,
  L4RE_KEY_MAX              = 0x1ff,
};

enum L4Re_events_rel
{
  L4RE_REL_X      = 0x00,
  L4RE_REL_Y      = 0x01,
  L4RE_REL_Z      = 0x02,
  L4RE_REL_RX     = 0x03,
  L4RE_REL_RY     = 0x04,
  L4RE_REL_RZ     = 0x05,
  L4RE_REL_HWHEEL = 0x06,
  L4RE_REL_DIAL   = 0x07,
  L4RE_REL_WHEEL  = 0x08,
  L4RE_REL_MISC   = 0x09,
  L4RE_REL_MAX    = 0x0f,
};

enum L4Re_events_snd
{
  L4RE_SND_CLICK = 0x00,
  L4RE_SND_BELL  = 0x01,
  L4RE_SND_TONE  = 0x02,
  L4RE_SND_MAX   = 0x07,
};

enum L4Re_events_rep
{
  L4RE_REP_DELAY  = 0x00,
  L4RE_REP_PERIOD = 0x01,
  L4RE_REP_MAX    = 0x01,
};

enum L4Re_events_led
{
  L4RE_LED_NUML     = 0x00,
  L4RE_LED_CAPSL    = 0x01,
  L4RE_LED_SCROLLL  = 0x02,
  L4RE_LED_COMPOSE  = 0x03,
  L4RE_LED_KANA     = 0x04,
  L4RE_LED_SLEEP    = 0x05,
  L4RE_LED_SUSPEND  = 0x06,
  L4RE_LED_MUTE     = 0x07,
  L4RE_LED_MISC     = 0x08,
  L4RE_LED_MAIL     = 0x09,
  L4RE_LED_CHARGING = 0x0a,
  L4RE_LED_MAX      = 0x0f,
};

enum L4Re_events_btn
{
  L4RE_BTN_MISC           = 0x100,
  L4RE_BTN_0              = 0x100,
  L4RE_BTN_1              = 0x101,
  L4RE_BTN_2              = 0x102,
  L4RE_BTN_3              = 0x103,
  L4RE_BTN_4              = 0x104,
  L4RE_BTN_5              = 0x105,
  L4RE_BTN_6              = 0x106,
  L4RE_BTN_7              = 0x107,
  L4RE_BTN_8              = 0x108,
  L4RE_BTN_9              = 0x109,
  L4RE_BTN_MOUSE          = 0x110,
  L4RE_BTN_LEFT           = 0x110,
  L4RE_BTN_RIGHT          = 0x111,
  L4RE_BTN_MIDDLE         = 0x112,
  L4RE_BTN_SIDE           = 0x113,
  L4RE_BTN_EXTRA          = 0x114,
  L4RE_BTN_FORWARD        = 0x115,
  L4RE_BTN_BACK           = 0x116,
  L4RE_BTN_TASK           = 0x117,
  L4RE_BTN_JOYSTICK       = 0x120,
  L4RE_BTN_TRIGGER        = 0x120,
  L4RE_BTN_THUMB          = 0x121,
  L4RE_BTN_THUMB2         = 0x122,
  L4RE_BTN_TOP            = 0x123,
  L4RE_BTN_TOP2           = 0x124,
  L4RE_BTN_PINKIE         = 0x125,
  L4RE_BTN_BASE           = 0x126,
  L4RE_BTN_BASE2          = 0x127,
  L4RE_BTN_BASE3          = 0x128,
  L4RE_BTN_BASE4          = 0x129,
  L4RE_BTN_BASE5          = 0x12a,
  L4RE_BTN_BASE6          = 0x12b,
  L4RE_BTN_DEAD           = 0x12f,
  L4RE_BTN_GAMEPAD        = 0x130,
  L4RE_BTN_A              = 0x130,
  L4RE_BTN_B              = 0x131,
  L4RE_BTN_C              = 0x132,
  L4RE_BTN_X              = 0x133,
  L4RE_BTN_Y              = 0x134,
  L4RE_BTN_Z              = 0x135,
  L4RE_BTN_TL             = 0x136,
  L4RE_BTN_TR             = 0x137,
  L4RE_BTN_TL2            = 0x138,
  L4RE_BTN_TR2            = 0x139,
  L4RE_BTN_SELECT         = 0x13a,
  L4RE_BTN_START          = 0x13b,
  L4RE_BTN_MODE           = 0x13c,
  L4RE_BTN_THUMBL         = 0x13d,
  L4RE_BTN_THUMBR         = 0x13e,
  L4RE_BTN_DIGI           = 0x140,
  L4RE_BTN_TOOL_PEN       = 0x140,
  L4RE_BTN_TOOL_RUBBER    = 0x141,
  L4RE_BTN_TOOL_BRUSH     = 0x142,
  L4RE_BTN_TOOL_PENCIL    = 0x143,
  L4RE_BTN_TOOL_AIRBRUSH  = 0x144,
  L4RE_BTN_TOOL_FINGER    = 0x145,
  L4RE_BTN_TOOL_MOUSE     = 0x146,
  L4RE_BTN_TOOL_LENS      = 0x147,
  L4RE_BTN_TOUCH          = 0x14a,
  L4RE_BTN_STYLUS         = 0x14b,
  L4RE_BTN_STYLUS2        = 0x14c,
  L4RE_BTN_TOOL_DOUBLETAP = 0x14d,
  L4RE_BTN_TOOL_TRIPLETAP = 0x14e,
  L4RE_BTN_WHEEL          = 0x150,
  L4RE_BTN_GEAR_DOWN      = 0x150,
  L4RE_BTN_GEAR_UP        = 0x151,
};

enum L4Re_events_sw
{
  L4RE_SW_0   = 0x00,
  L4RE_SW_1   = 0x01,
  L4RE_SW_2   = 0x02,
  L4RE_SW_3   = 0x03,
  L4RE_SW_4   = 0x04,
  L4RE_SW_5   = 0x05,
  L4RE_SW_6   = 0x06,
  L4RE_SW_7   = 0x07,
  L4RE_SW_MAX = 0x0f,
};

enum L4Re_events_ev
{
  L4RE_EV_SYN       = 0x00,
  L4RE_EV_KEY       = 0x01,
  L4RE_EV_REL       = 0x02,
  L4RE_EV_ABS       = 0x03,
  L4RE_EV_MSC       = 0x04,
  L4RE_EV_SW        = 0x05,
  L4RE_EV_LED       = 0x11,
  L4RE_EV_SND       = 0x12,
  L4RE_EV_REP       = 0x14,
  L4RE_EV_FF        = 0x15,
  L4RE_EV_PWR       = 0x16,
  L4RE_EV_FF_STATUS = 0x17,
  L4RE_EV_WINDOW    = 0x18,
  L4RE_EV_PM        = 0x1e, // power management signals
  L4RE_EV_MAX       = 0x1f,
};

enum L4Re_events_syn
{
  L4RE_SYN_REPORT    = 0,
  L4RE_SYN_CONFIG    = 1,
  L4RE_SYN_MT_REPORT = 2,

  L4RE_SYN_STREAM_CFG    = 0x80, ///< cfg stream (L4Re specififc syn code)
};

enum L4Re_stream_cfg
{
  L4RE_SYN_STREAM_NEW   = 0,
  L4RE_SYN_STREAM_CLOSE = 1,
};

enum L4Re_events_abs
{
  L4RE_ABS_X              = 0x00,
  L4RE_ABS_Y              = 0x01,
  L4RE_ABS_Z              = 0x02,
  L4RE_ABS_RX             = 0x03,
  L4RE_ABS_RY             = 0x04,
  L4RE_ABS_RZ             = 0x05,
  L4RE_ABS_THROTTLE       = 0x06,
  L4RE_ABS_RUDDER         = 0x07,
  L4RE_ABS_WHEEL          = 0x08,
  L4RE_ABS_GAS            = 0x09,
  L4RE_ABS_BRAKE          = 0x0a,
  L4RE_ABS_HAT0X          = 0x10,
  L4RE_ABS_HAT0Y          = 0x11,
  L4RE_ABS_HAT1X          = 0x12,
  L4RE_ABS_HAT1Y          = 0x13,
  L4RE_ABS_HAT2X          = 0x14,
  L4RE_ABS_HAT2Y          = 0x15,
  L4RE_ABS_HAT3X          = 0x16,
  L4RE_ABS_HAT3Y          = 0x17,
  L4RE_ABS_PRESSURE       = 0x18,
  L4RE_ABS_DISTANCE       = 0x19,
  L4RE_ABS_TILT_X         = 0x1a,
  L4RE_ABS_TILT_Y         = 0x1b,
  L4RE_ABS_TOOL_WIDTH     = 0x1c,
  L4RE_ABS_VOLUME         = 0x20,
  L4RE_ABS_MISC           = 0x28,
  L4RE_ABS_MT_TOUCH_MAJOR = 0x30,
  L4RE_ABS_MT_TOUCH_MINOR = 0x31,
  L4RE_ABS_MT_WIDTH_MAJOR = 0x32,
  L4RE_ABS_MT_WIDTH_MINOR = 0x33,
  L4RE_ABS_MT_ORIENTATION = 0x34,
  L4RE_ABS_MT_POSITION_X  = 0x35,
  L4RE_ABS_MT_POSITION_Y  = 0x36,
  L4RE_ABS_MT_TOOL_TYPE   = 0x37,
  L4RE_ABS_MT_BLOB_ID     = 0x38,
  L4RE_ABS_MT_TRACKING_ID = 0x39,
  L4RE_ABS_MT_PRESSURE    = 0x3a,
  L4RE_ABS_MT_DISTANCE    = 0x3b,

  L4RE_ABS_MAX            = 0x3f,
};

enum L4Re_events_msc
{
  L4RE_MSC_SERIAL   = 0x00,
  L4RE_MSC_PULSELED = 0x01,
  L4RE_MSC_GESTURE  = 0x02,
  L4RE_MSC_RAW      = 0x03,
  L4RE_MSC_SCAN     = 0x04,
  L4RE_MSC_MAX      = 0x07,
};

enum L4Re_events_properties
{
  L4RE_EVENT_PROP_POINTER    = 0x00,
  L4RE_EVENT_PROP_DIRECT     = 0x01,
  L4RE_EVENT_PROP_BUTTONPAD  = 0x02,
  L4RE_EVENT_PROP_SEMI_MT    = 0x03,
  //L4RE_EVENT_PROP_MAX        = 0x1f
};
