-- vi:ft=lua

local Hw = Io.Hw
local hw_bus = Io.system_bus()

-- add devices to io's device tree
Io.hw_add_devices(function()

  -- create a new hardware device
  S2_btn = Hw.Device(function()
    -- Set the 'compatible' IDs for the device
    compatible = {"gpio-input,btn","gpio-key"};

    -- Set the 'hid' property of the device
    Property.hid = "gpio-key,S2";

    -- Add a GPIO pin as a resource to the device
    -- on Pandaboard this is the S2 push button
    Resource.key = Io.Gpio_resource(hw_bus.GPIO.GPIO4, 25, 25);
  end);
end)
