-- vi:ft=lua

local Hw = Io.Hw
local hw_bus = Io.system_bus()

-- add devices to io's device tree
Io.hw_add_devices(function()

  -- create a new hardware device
  S4_btn = Hw.Device(function()
    -- Set the 'compatible' IDs for this device
    compatible = {"gpio-input,btn","gpio-key"};

    -- Set the 'hid' property of the device
    Property.hid = "gpio-key,S4";

    -- Add a GPIO pin as resource 'btn0' to the device
    -- on Omap5uevm this is the S4 push button
    Resource.key = Io.Gpio_resource(hw_bus.GPIO.GPIO3, 19, 19);
  end);
end)
