/*
 * Copyright (C) 2021, 2024 Kernkonzept GmbH.
 * Author(s): Georg Kotheimer <georg.kotheimer@kernkonzept.com>
 *
 * License: see LICENSE.spdx (in this directory or the directories above)
 */
#pragma once

#include "uart_base.h"

namespace L4 {

class Uart_sbi : public Uart
{
public:
  Uart_sbi();
  explicit Uart_sbi(unsigned /*base_rate*/) : Uart_sbi() {}
  bool startup(Io_register_block const *) override;
  void shutdown() override;
  bool change_mode(Transfer_mode m, Baud_rate r) override;
  int tx_avail() const { return true; }
  void wait_tx_done() const {}
  inline void out_char(char c) const;
  int write(char const *s, unsigned long count,
            bool blocking = true) const override;

#ifndef UART_WITHOUT_INPUT
  int char_avail() const override;
  int get_char(bool blocking = true) const override;
#endif

private:
  mutable int _bufchar;
};

} // namespace L4
