INTERFACE:

#include "assert.h"
#include "obj_space_phys_util.h"

EXTENSION class Generic_obj_space : Obj_space_phys<Generic_obj_space< SPACE > >
{
private:
  typedef Obj_space_phys<Generic_obj_space< SPACE > > Base;

public:
  using Base::initialize;

  static Ram_quota * __attribute__((nonnull(1))) ram_quota(Base const *base)
  {
    assert(base);
    return static_cast<SPACE const *>(base)->ram_quota();
  }
};


//----------------------------------------------------------------------------
IMPLEMENTATION:

//
// Utilities for map<Generic_obj_space> and unmap<Generic_obj_space>
//

IMPLEMENT template< typename SPACE >
inline
bool FIASCO_FLATTEN
Generic_obj_space<SPACE>::v_lookup(V_pfn const &virt, Phys_addr *phys,
                                   Page_order *order, Attr *attribs)
{ return Base::v_lookup(virt, phys, order, attribs); }

IMPLEMENT template< typename SPACE >
inline
typename Generic_obj_space<SPACE>::Capability FIASCO_FLATTEN
Generic_obj_space<SPACE>::lookup(Cap_index virt)
{ return Base::lookup(virt); }

IMPLEMENT template< typename SPACE >
inline
Kobject_iface * FIASCO_FLATTEN __attribute__((nonnull))
Generic_obj_space<SPACE>::lookup_local(Cap_index virt, L4_fpage::Rights *rights)
{ return Base::lookup_local(virt, rights); }

IMPLEMENT template< typename SPACE >
inline
Page::Flags FIASCO_FLATTEN
Generic_obj_space<SPACE>::v_delete(V_pfn virt, Page_order order,
                                   Page::Rights rights)
{ return Base::v_delete(virt, order, rights); }

IMPLEMENT template< typename SPACE >
inline
typename Generic_obj_space<SPACE>::Status FIASCO_FLATTEN
Generic_obj_space<SPACE>::v_insert(Phys_addr phys, V_pfn const &virt,
                                   Page_order order, Attr page_attribs)
{ return static_cast<Status>(Base::v_insert(phys, virt, order, page_attribs)); }

IMPLEMENT template< typename SPACE >
inline
typename Generic_obj_space<SPACE>::V_pfn FIASCO_FLATTEN
Generic_obj_space<SPACE>::obj_map_max_address() const
{ return Base::obj_map_max_address(); }

// ------------------------------------------------------------------------------
IMPLEMENTATION [debug]:

PUBLIC template< typename SPACE > static inline
SPACE *
Generic_obj_space<SPACE>::get_space(Base *base)
{ return static_cast<SPACE*>(base); }

IMPLEMENT template< typename SPACE > inline
typename Generic_obj_space<SPACE>::Entry *
Generic_obj_space<SPACE>::jdb_lookup_cap(Cap_index index)
{ return Base::jdb_lookup_cap(index); }

// ------------------------------------------------------------------------------
IMPLEMENTATION [!debug]:

PUBLIC template< typename SPACE > static inline
SPACE *
Generic_obj_space<SPACE>::get_space(Base *)
{ return nullptr; }
