IMPLEMENTATION [arm && (pf_rpi_rpi2 || pf_rpi_rpi3)]:

#include "timer.h"
#include "arm_control.h"

IMPLEMENT
void
Timer_tick::setup(Cpu_number cpu)
{
  enable_vkey(cpu);
}

IMPLEMENT
void
Timer_tick::enable(Cpu_number)
{
  Arm_control::o()->timer_unmask(Timer::irq());
  Timer::enable();
}

IMPLEMENT
void
Timer_tick::disable(Cpu_number)
{
  Arm_control::o()->timer_mask(Timer::irq());
}

PUBLIC static inline
void
Timer_tick::ack()
{
  Timer::acknowledge();
}

